try {
  var geoip = {};
  window.geoip = geoip;
} catch (err) {
  window.geoip = {};
}

try {
  window.modelData = window.diagnostics.getModel();
} catch (err) {
  window.modelData = {type: 'unknown', vendor: 'unknown'};
}

var usaLocales = [
  'US',
  'CA'
];
var euLocales = [
  'AT',
  'BE',
  'BG',
  'CZ',
  'DE',
  'DK',
  'EE',
  'ES',
  'FI',
  'FR',
  'GB',
  'GR',
  'HR',
  'HU',
  'IE',
  'IT',
  'LT',
  'LU',
  'LV',
  'MT',
  'NL',
  'PL',
  'PT',
  'RO',
  'SE',
  'SI',
  'SK'
];
var usaLocalesOpera = [ ];
var euLocalesOpera = [ ];
var cisLocales = [
  'RU',
  'AZ',
  'AM',
  'BY',
  'KZ',
  'KG',
  'MD',
  'TJ',
  'TM',
  'UZ',
  'GE',
  'AB',
  'OS'
];
var cloudLocales = [
  'GH',
  'IN',
  'KE',
  'NG',
  'PK',
  'SD',
  'TZ',
  'UG',
  'ZA'
];

function checkCloudTargeting (data) {
  if (data.os.OSVersion < 6) { return false; }
  var geo = data.geoip.geoip_country_code.toUpperCase();
  if ((usaLocales.indexOf(geo) !== -1) || (euLocales.indexOf(geo) !== -1)) { return false; }
  if (cloudLocales.indexOf(geo) !== -1) { return true; }
  if (window.lang !== 'ru') { return false; }
  return true;
}

function isCloudInstalled (data) {
  if (data.system.RegExists('HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\DriverPack Cloud\\DisplayName')) { return true; }
  return false;
}

var soft = [
  {
    'ID': '0',
    'Name': '7-Zip',
    'URL': 'http://dl.driverpack.io/soft/7-Zip.exe',
    'Icon': 'http://dl.driverpack.io/soft/7-Zip.png',
    'Publisher': 'Igor Pavlov',
    'Rating': 5,
    'Checked': false,
    'Version': '21.03',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-07-21',
    'Registry_32': 'HKCU\\Software\\7-Zip\\Path',
    'Keys': '/S',
    'Category': 'Archiver',
    'Description': {
      'en': '7-Zip  file archiver with a high compression ratio',
      'ru': '7-Zip       '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1001
  },
  {
    'ID': '3',
    'Name': 'Opera x64',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink64.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (!data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) !== -1) || (euLocalesOpera.indexOf(geo) !== -1)) { return false; }
      if (geo === 'RU') return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '3a',
    'Name': 'Opera x64',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink64_win7.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (!data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) !== -1) || (euLocalesOpera.indexOf(geo) !== -1)) { return false; }
      if (geo === 'RU') return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '4',
    'Name': 'Opera US x64',
    'URL': 'http://dl.driverpack.io/soft/OperaBlink64.exe',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'confirmPopup': {
      'description': {
        'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
        'ru': ',          ,      VPN'
      },
      'isDeferred': true
    },
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (!data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) === -1) && (euLocalesOpera.indexOf(geo) === -1)) { return false; }
      if (cisLocales.indexOf(geo) !== -1) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '4a',
    'Name': 'Opera US x64',
    'URL': 'http://dl.driverpack.io/soft/OperaBlink64_win7.exe',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'confirmPopup': {
      'description': {
        'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
        'ru': ',          ,      VPN'
      },
      'isDeferred': true
    },
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (!data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) === -1) && (euLocalesOpera.indexOf(geo) === -1)) { return false; }
      if (cisLocales.indexOf(geo) !== -1) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '5',
    'Name': 'Opera',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) !== -1) || (euLocalesOpera.indexOf(geo) !== -1)) { return false; }
      if (geo === 'RU') return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '5a',
    'Name': 'Opera',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink_win7.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) !== -1) || (euLocalesOpera.indexOf(geo) !== -1)) { return false; }
      if (geo === 'RU') return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '6',
    'Name': 'Opera US',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'confirmPopup': {
      'description': {
        'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
        'ru': ',          ,      VPN'
      },
      'isDeferred': true
    },
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) === -1) && (euLocalesOpera.indexOf(geo) === -1)) { return false; }
      if (cisLocales.indexOf(geo) !== -1) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '6a',
    'Name': 'Opera US',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaBlink_win7.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'confirmPopup': {
      'description': {
        'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
        'ru': ',          ,      VPN'
      },
      'isDeferred': true
    },
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (data.os.is64) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if ((usaLocalesOpera.indexOf(geo) === -1) && (euLocalesOpera.indexOf(geo) === -1)) { return false; }
      if (cisLocales.indexOf(geo) !== -1) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '7',
    'Name': 'Opera CIS x64',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/Opera64cis_woGoogle.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return true; }
      if (geo === 'UA') { return true; }
      if (geo === 'BY') { return true; }
      if (geo === 'KZ') { return true; }
      if (geo === 'AZ') { return true; }
      if (geo === 'TM') { return true; }
      if (geo === 'TJ') { return true; }
      if (geo === 'AM') { return true; }
      if (geo === 'MD') { return true; }
      if (geo === 'KG') { return true; }
      if (geo === 'UZ') { return true; }
      if (geo === 'GE') { return true; }
      if (geo === 'AB') { return true; }
      if (geo === 'OS') { return true; }
      return false;
    },
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (!data.os.is64) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '7a',
    'Name': 'Opera CIS x64',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/Opera64cis_woGoogle_win7.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return true; }
      if (geo === 'UA') { return true; }
      if (geo === 'BY') { return true; }
      if (geo === 'KZ') { return true; }
      if (geo === 'AZ') { return true; }
      if (geo === 'TM') { return true; }
      if (geo === 'TJ') { return true; }
      if (geo === 'AM') { return true; }
      if (geo === 'MD') { return true; }
      if (geo === 'KG') { return true; }
      if (geo === 'UZ') { return true; }
      if (geo === 'GE') { return true; }
      if (geo === 'AB') { return true; }
      if (geo === 'OS') { return true; }
      return false;
    },
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (!data.os.is64) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '8',
    'Name': 'Opera CIS',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/Opera86cis_woGoogle.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return true; }
      if (geo === 'UA') { return true; }
      if (geo === 'BY') { return true; }
      if (geo === 'KZ') { return true; }
      if (geo === 'AZ') { return true; }
      if (geo === 'TM') { return true; }
      if (geo === 'TJ') { return true; }
      if (geo === 'AM') { return true; }
      if (geo === 'MD') { return true; }
      if (geo === 'KG') { return true; }
      if (geo === 'UZ') { return true; }
      if (geo === 'GE') { return true; }
      if (geo === 'AB') { return true; }
      if (geo === 'OS') { return true; }
      return false;
    },
    'Version': '101.0.4843.43',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2023-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion <= 6.1) return false;
      if (data.os.is64) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '8a',
    'Name': 'Opera CIS',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/Opera86cis_woGoogle_win7.exe',
    'Icon': 'http://dl.driverpack.io/soft/Opera.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return true; }
      if (geo === 'UA') { return true; }
      if (geo === 'BY') { return true; }
      if (geo === 'KZ') { return true; }
      if (geo === 'AZ') { return true; }
      if (geo === 'TM') { return true; }
      if (geo === 'TJ') { return true; }
      if (geo === 'AM') { return true; }
      if (geo === 'MD') { return true; }
      if (geo === 'KG') { return true; }
      if (geo === 'UZ') { return true; }
      if (geo === 'GE') { return true; }
      if (geo === 'AB') { return true; }
      if (geo === 'OS') { return true; }
      return false;
    },
    'Version': '64.0.3417.73',
    'ReleaseDate': '2017-10-04',
    'UpdateDate': '2019-10-24',
    'Registry_32': 'HKCU\\Software\\Opera Software\\UUID',
    'CheckInstalled': function (data) {
      return data.diagnostics.checkSoft.checkSoftInstalled(/^Opera /i);
    },
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6.1) return false;
      if (data.os.is64) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '9',
    'Name': 'Opera XP',
    'localizedName': {
      'en': 'Opera Browser',
      'ru': ' Opera'
    },
    'URL': 'http://dl.driverpack.io/soft/OperaXP.exe',
    'Icon': 'http://dl.driverpack.io/soft/OperaXP.png',
    'Publisher': 'Opera Software',
    'Rating': 5,
    'Checked': true,
    'Version': '36.0.2130.80',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-12-23',
    'Registry_32': 'HKCU\\Software\\Opera Software\\Last Stable Install Path',
    'Keys': '-install -silent -launchopera=1 -setdefaultbrowser=1',
    'Category': 'Browser',
    'hideWindow': 'Opera',
    'eula': 'http://www.opera.com/eula/computers',
    'policy': 'http://www.opera.com/privacy',
    'about': 'https://www.opera.com/computer',
    'Description': {
      'en': 'Fast, secure, easy-to-use browser with a built-in ad blocker, battery saver and free VPN',
      'ru': ',          ,      VPN'
    },
    'Targeting': function (data) {
      if (data.os.OSVersion >= 6) return false;
      return true;
    },
    'Lang': '',
    'IsPartner': true,
    'priority': 41
  },
  {
    'ID': '10',
    'Name': 'Yandex.Browser',
    'URL': 'http://dl.driverpack.io/soft/ab/downloader_browser.exe',
    'Icon': 'http://dl.driverpack.io/soft/Yandex.png',
    'Publisher': 'YANDEX LLC',
    'Rating': 5,
    'Checked': true,
    'Version': '23.1.2',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2023-12-25',
    'Registry_32': 'HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\YandexBrowser\\DisplayName',
    'CheckInstalled': function (data) {
      return data.system.RegExists('HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\YandexBrowser\\DisplayName') &&
        data.system.RegExists('HKCU\\Software\\drpsu\\YandexInstalled');
    },
    'Keys': '--sync --partner 129773 --distr /quiet /msicl "YABROWSER=y YAHOMEPAGE=y YAQSEARCH=y YBSENDSTAT=n YBDEFAULT=n ILIGHT=1 VID="306"" --try 10 /log "%temp%\\YaBrInstall.log"',
    'OfflineKeys': '/quiet /msicl "YAHOMEPAGE=y YAQSEARCH=y YABROWSER=y YBSENDSTAT=n YBDEFAULT=n VID="003""',
    'Category': 'Browser',
    'hideWindow': 'Browser',
    'confirmPopup': {
      'description': {
        'en': 'Yandex Browser is another Chrome based browser featuring a fast minimalist interface with unique features like Stealth Mode.',
        'ru': '  -,          -,     ,   ,        .'
      }
    },
    'eula': 'https://yandex.ru/legal/browser_agreement/',
    'policy': 'https://yandex.ru/legal/confidential/',
    'about': 'https://getyabrowser.com',
    'Description': {
      'en': 'Yandex.Browser  a quick and safe web-browser with active security system Protect!',
      'ru': '.        Protect!'
    },
    'IsPartner': true,
    'Targeting': function (data) {
      if (window.lang !== 'ru' &&
          window.lang !== 'by' &&
          window.lang !== 'kz' &&
          window.lang !== 'kg' &&
          window.lang !== 'kgz' &&
          window.lang !== 'uz' &&
          window.lang !== 'tz' &&
          window.lang !== 'am' &&
          window.lang !== 'az' &&
          window.lang !== 'md' &&
          window.lang !== 'tm') {
        return false;
      }
      if (data.os.OSVersion === '6.1' && data.os.is64) {
        return false;
      }
      if (Math.random() < 0.3) {
        return false;
      }
      return true;
    },
    'Lang': 'rus',
    'priority': 31,
    'afterHook': function (data) {
      // Remove shortcuts
      var folder = data.system.WshShell.ExpandEnvironmentStrings('%appdata%\\Microsoft\\Internet Explorer\\Quick Launch\\User Pinned\\TaskBar');
      var shortcuts = ['.website'];
      for (var i = 0; i < shortcuts.length; i++) {
        try {
          var verbs = data.system.objShell.Namespace(folder).ParseName(shortcuts[i]).Verbs();
          for (var j = 0; j < verbs.Count; j++) {
            if (/unpin|/i.test(verbs.Item(j).name)) verbs.Item(j).DoIt();
          }
        } catch (e) {}
        try {
          data.system.fso.DeleteFile(folder + '\\' + shortcuts[i], true);
        } catch (e) {}
      }
      // Write install
      try {
        data.system.RegWrite('HKCU\\Software\\drpsu\\YandexInstalled', Date.now());
      } catch (e) {}
    }
  },
  {
    'ID': '12',
    'Name': 'Foxit PDF Reader',
    'URL': 'http://dl.driverpack.io/soft/FoxitReader.exe',
    'Icon': 'http://dl.driverpack.io/soft/FoxitReader.png',
    'Publisher': 'Foxit Software Inc.',
    'Rating': 4,
    'Checked': false,
    'Version': '11.0.1.49938',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-09-02',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Foxit Reader_is1\\DisplayName',
    'Keys': '-y -gm2 -fm0',
    'Category': 'Viewer',
    'Description': {
      'en': 'Foxit PDF Reader  view, create, annotate, and Print PDF Files',
      'ru': 'Foxit PDF Reader        PDF'
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1011
  },
  {
    'ID': '13',
    'Name': 'K-Lite Codec Pack',
    'URL': 'http://dl.driverpack.io/soft/K-LiteXP.exe',
    'Icon': 'http://dl.driverpack.io/soft/K-Lite.png',
    'Publisher': 'KLCP',
    'Rating': 5,
    'Checked': false,
    'Version': '13.8.5',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-03-04',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\KLiteCodecPack_is1\\DisplayName',
    'Keys': '/VERYSILENT /NORESTART /SUPPRESSMSGBOXES',
    'Category': 'Viewer',
    'Description': {
      'en': 'K-Lite Codec Pack contains everything you need to play all popular audio and video file formats',
      'ru': 'K-Lite Codec Pack        '
    },
    'Targeting': function (data) {
      if (data.os.OSVersion > 6) { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '[ru,tt,uk,az,be,uz,hy,ka]',
    'priority': 1021
  },
  {
    'ID': '14',
    'Name': 'K-Lite Codec Pack',
    'URL': 'http://dl.driverpack.io/soft/K-Lite.exe',
    'Icon': 'http://dl.driverpack.io/soft/K-Lite.png',
    'Publisher': 'KLCP',
    'Rating': 5,
    'Checked': false,
    'Version': '16.3.5',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-09-01',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\KLiteCodecPack_is1\\DisplayName',
    'Keys': '/VERYSILENT /NORESTART /SUPPRESSMSGBOXES',
    'Category': 'Viewer',
    'Description': {
      'en': 'K-Lite Codec Pack contains everything you need to play all popular audio and video file formats',
      'ru': 'K-Lite Codec Pack        '
    },
    'Targeting': function (data) {
      if (data.os.OSVersion < 6) return false;
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '[ru,tt,uk,az,be,uz,hy,ka]',
    'priority': 1021
  },
  {
    'ID': '15',
    'Name': 'Skype',
    'URL': 'http://dl.driverpack.io/soft/SkypeXP.exe',
    'Icon': 'http://dl.driverpack.io/soft/Skype.png',
    'Publisher': 'Skype Technologies S.A.',
    'Rating': 4,
    'Checked': false,
    'Version': '7.36.0.101',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2017-05-09',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{FC965A47-4839-40CA-B618-18F486F042C6}\\DisplayName',
    'Keys': '/VERYSILENT /NOLAUNCH /NOGOOGLE /NOSTARTUP /NOPLUGINS',
    'Category': 'Messenger',
    'Description': {
      'en': 'Skype keeps the world talking, for free',
      'ru': 'Skype     '
    },
    'Targeting': function (data) {
      if (data.os.OSVersion >= 6) { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1031
  },
  {
    'ID': '16',
    'Name': 'Skype',
    'URL': 'http://dl.driverpack.io/soft/SkypeNew.exe',
    'Icon': 'http://dl.driverpack.io/soft/Skype.png',
    'Publisher': 'Skype Technologies S.A.',
    'Rating': 4,
    'Checked': false,
    'Version': '8.75.0.140',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-09-01',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Skype_is1\\DisplayName',
    'Keys': '/VERYSILENT /NOLAUNCH /NOGOOGLE /NOSTARTUP /NOPLUGINS',
    'Category': 'Messenger',
    'Description': {
      'en': 'Skype keeps the world talking, for free',
      'ru': 'Skype     '
    },
    'Targeting': function (data) {
      if (data.os.OSVersion < 6) { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1031
  },
  {
    'ID': '17',
    'Name': 'uTorrent',
    'URL': 'http://dl.driverpack.io/soft/uTorrent.exe',
    'Icon': 'http://dl.driverpack.io/soft/uTorrent.png',
    'Publisher': 'BitTorrent, Inc.',
    'Rating': 4,
    'Checked': false,
    'Version': '3.5.3.44358',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2018-03-06',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\uTorrent\\DisplayName',
    'Keys': '-aiA -gm2 -fm0',
    'Category': 'Internet',
    'Description': {
      'en': 'uTorrent  elegant and efficient torrent downloading',
      'ru': 'uTorrent  ,    -'
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1041
  },
  {
    'ID': '18',
    'Name': 'PotPlayer',
    'URL': 'http://dl.driverpack.io/soft/PotPlayer.exe',
    'Icon': 'http://dl.driverpack.io/soft/PotPlayer.png',
    'Publisher': 'Kakao Corporation',
    'Rating': 5,
    'Checked': false,
    'Version': '1.7.21526',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2023-09-01',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\PotPlayer\\DisplayName',
    'Keys': '/S',
    'Category': 'Player',
    'Description': {
      'en': 'PotPlayer  universal multimedia player with integrated codecs',
      'ru': 'PotPlayer       '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1050
  },
  {
    'ID': '19',
    'Name': 'AIMP',
    'URL': 'http://dl.driverpack.io/soft/AIMP.exe',
    'Icon': 'http://dl.driverpack.io/soft/AIMP.png',
    'Publisher': 'Artem Izmaylov',
    'Rating': 5,
    'Checked': false,
    'Version': '4.70.2245',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2021-09-01',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\AIMP\\DisplayName',
    'Keys': '/AUTO="%PROGRAMFILES%\\AIMP"',
    'Category': 'Player',
    'Description': {
      'en': 'AIMP  simple and high-quality audio player',
      'ru': 'AIMP      '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1051
  },
  {
    'ID': '20',
    'Name': 'Chrone Browser',
    'URL': 'http://dl.driverpack.io/soft/Chrone.exe',
    'Icon': 'http://dl.driverpack.io/soft/Chrone.png',
    'Publisher': 'Internet-Start.net',
    'Rating': 5,
    'Checked': true,
    'Version': '86.0.4240.198',
    'ReleaseDate': '2018-10-01',
    'UpdateDate': '2020-12-23',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Chrone Browser\\DisplayName',
    'Keys': '/S',
    'Category': 'Browser',
    'Description': {
      'en': 'Free Chromium based browser',
      'ru': '     Chromium'
    },
    'IsPartner': true,
    'Lang': '',
    'priority': 21
  },
  {
    'ID': '6-86ru',
    'Name': 'Firefox Rus',
    'localizedName': {
      'en': 'Firefox Browser',
      'ru': ' Firefox'
    },
    'URL': 'http://dl.driverpack.io/soft/FirefoxRu.exe',
    'Icon': 'http://dl.driverpack.io/soft/Firefox.png',
    'Publisher': 'Mozilla Corporation',
    'Rating': 5,
    'Checked': true,
    'Version': '93.0',
    'ReleaseDate': '2018-09-05',
    'UpdateDate': '2021-10-05',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Firefox Browser\\DisplayName',
    'Keys': '/S',
    'Category': 'Browser',
    'eula': 'https://www.mozilla.org/en-US/about/legal/eula/',
    'policy': 'https://www.mozilla.org/en-US/privacy/',
    'about': 'https://www.mozilla.org/firefox/',
    'Description': {
      'en': 'Firefox  browser, committed to you, your privacy and an open Web',
      'ru': 'Firefox  ,  ,     '
    },
    'Targeting': function (data) {
      if (window.lang !== 'ru' &&
          window.lang !== 'az' &&
          window.lang !== 'be' &&
          window.lang !== 'hy' &&
          window.lang !== 'tt' &&
          window.lang !== 'uk' &&
          window.lang !== 'uz') { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': true,
    'Lang': '',
    'priority': 22
  },
  {
    'ID': '6-86en',
    'Name': 'Firefox Eng',
    'localizedName': {
      'en': 'Firefox Browser',
      'ru': ' Firefox'
    },
    'URL': 'http://dl.driverpack.io/soft/FirefoxEn.exe',
    'Icon': 'http://dl.driverpack.io/soft/Firefox.png',
    'Publisher': 'Mozilla Corporation',
    'Rating': 5,
    'Checked': true,
    'Version': '93.0',
    'ReleaseDate': '2018-09-05',
    'UpdateDate': '2021-10-05',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Firefox Browser\\DisplayName',
    'Keys': '/S',
    'Category': 'Browser',
    'eula': 'https://www.mozilla.org/en-US/about/legal/eula/',
    'policy': 'https://www.mozilla.org/en-US/privacy/',
    'about': 'https://www.mozilla.org/firefox/',
    'Description': {
      'en': 'Firefox  browser, committed to you, your privacy and an open Web',
      'ru': 'Firefox  ,  ,     '
    },
    'Targeting': function (data) {
      if (window.lang === 'ru' ||
          window.lang === 'az' ||
          window.lang === 'be' ||
          window.lang === 'hy' ||
          window.lang === 'tt' ||
          window.lang === 'uk' ||
          window.lang === 'uz') { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': true,
    'Lang': '',
    'priority': 22
  },
  {
    'ID': '21',
    'Name': 'FastStone Image Viewer',
    'URL': 'http://dl.driverpack.io/soft/FSImage.exe',
    'Icon': 'http://dl.driverpack.io/soft/FSImage.png',
    'Publisher': 'FastStone Soft',
    'Rating': 4,
    'Checked': false,
    'Version': '7.5',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2020-03-27',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\FastStone Image Viewer\\DisplayName',
    'Keys': '/S',
    'Category': 'Viewer',
    'Description': {
      'en': 'FastStone Image Viewer  image browser, converter and editor',
      'ru': 'FastStone Image Viewer       '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1071
  },
  {
    'ID': '22',
    'Name': 'TeamViewer',
    'URL': 'http://dl.driverpack.io/soft/TeamViewer.exe',
    'Icon': 'http://dl.driverpack.io/soft/TeamViewer.png',
    'Publisher': 'TeamViewer GmbH',
    'Rating': 5,
    'Checked': false,
    'Version': '15.43.9',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2023-07-19',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\TeamViewer\\DisplayName',
    'Keys': '/S',
    'Category': 'Internet',
    'Description': {
      'en': 'TeamViewer  tool for remote support, access and online meeting',
      'ru': 'TeamViewer        '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1081
  },
  {
    'ID': '23',
    'Name': 'AOMEI Backupper',
    'URL': 'http://dl.driverpack.io/soft/Backupper.exe',
    'Icon': 'http://dl.driverpack.io/soft/Backupper.png',
    'Publisher': 'AOMEI Technology Co., Ltd.',
    'Rating': 5,
    'Checked': false,
    'Version': '3.5',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2016-12-28',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{A83692F5-3E9B-4E95-9E7E-B5DF5536C09F}_is1\\DisplayName',
    'Keys': '/VERYSILENT /NORESTART /SUPPRESSMSGBOXES',
    'Category': 'Backup',
    'Description': {
      'en': 'AOMEI Backupper  the simplest FREE PC backupper',
      'ru': 'AOMEI Backupper        '
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1091
  },
  {
    'ID': '24',
    'Name': 'Adobe Flash Player',
    'URL': 'http://dl.driverpack.io/soft/FlashPlayer.exe',
    'Icon': 'http://dl.driverpack.io/soft/FlashPlayer.png',
    'Publisher': 'Adobe Systems Incorporated',
    'Rating': 5,
    'Checked': false,
    'Version': '32.0.0.465',
    'ReleaseDate': '2014-09-10',
    'UpdateDate': '2021-01-21',
    'Registry_32': 'HKLM\\Software\\MozillaPlugins\\@adobe.com/FlashPlayer\\Description',
    'Keys': '-y -gm2 -fm0',
    'Category': 'Viewer',
    'Description': {
      'en': 'Adobe Flash Player',
      'ru': 'Adobe Flash Player'
    },
    'Targeting': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1101
  },
  {
    'ID': '32',
    'Name': '360 Total Security',
    'URL': 'http://dl.driverpack.io/soft/360tsNew.exe',
    'Icon': 'http://dl.driverpack.io/soft/360ts.png',
    'Publisher': 'Qihoo 360 Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return true; }
      if (geo === 'US') { return true; }
      if (geo === 'KZ') { return true; }
      if (geo === 'PL') { return true; }
      if (geo === 'DE') { return true; }
      if (geo === 'NL') { return true; }
      if (geo === 'KR') { return true; }
      if (geo === 'CZ') { return true; }
      if (geo === 'FR') { return true; }
      if (geo === 'CA') { return true; }
      if (geo === 'IT') { return true; }
      if (geo === 'ES') { return true; }
      if (geo === 'HK') { return true; }
      if (geo === 'JP') { return true; }
      if (geo === 'SE') { return true; }
      if (geo === 'FI') { return true; }
      if (geo === 'SG') { return true; }
      if (geo === 'AT') { return true; }
      if (geo === 'IN') { return true; }
      if (geo === 'BR') { return true; }
      if (geo === 'UA') { return true; }
      if (geo === 'UZ') { return true; }
      if (geo === 'BY') { return true; }
      if (geo === 'TH') { return true; }
      if (geo === 'VN') { return true; }
      if (geo === 'MX') { return true; }
      if (geo === 'AR') { return true; }
      if (geo === 'PE') { return true; }
      return false;
    },
    'Version': '11.0.0.1028',
    'ReleaseDate': '2018-05-11',
    'UpdateDate': '2023-07-24',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\360TotalSecurity\\UninstallString',
    'Keys': '/s',
    'Category': 'Antivirus',
    'protect': true,
    'confirmPopup': {
      'description': {
        'en': '360 Total Security offers your PC complete protection from Viruses, Trojans and other emerging threats.',
        'ru': '360 Total Security        ,     .'
      }
    },
    'eula': 'https://www.360totalsecurity.com/license/360-total-security/',
    'policy': 'https://www.360totalsecurity.com/privacy/',
    'IsPartner': true,
    'Description': {
      'en': '360 Total Security offers your PC complete protection from Viruses, Trojans and other emerging threats',
      'ru': '360 Total Security        ,     '
    },
    'Lang': '',
    'priority': 1201,
    'afterHook': function (data) {
      // Write install
      try {
        data.system.RegWrite('HKCU\\Software\\drpsu\\360TSInstalled', Date.now());
      } catch (e) {}
    }
  },
  {
    'ID': '33',
    'Name': '360 Total Security',
    'URL': 'http://dl.driverpack.io/soft/360tsOld.exe',
    'Icon': 'http://dl.driverpack.io/soft/360ts.png',
    'Publisher': 'Qihoo 360 Software',
    'Rating': 5,
    'Checked': function (data) {
      var geo = data.geoip.geoip_country_code.toUpperCase();
      if (geo === 'RU') { return false; }
      if (geo === 'US') { return false; }
      if (geo === 'KZ') { return false; }
      if (geo === 'PL') { return false; }
      if (geo === 'DE') { return false; }
      if (geo === 'NL') { return false; }
      if (geo === 'KR') { return false; }
      if (geo === 'CZ') { return false; }
      if (geo === 'FR') { return false; }
      if (geo === 'CA') { return false; }
      if (geo === 'IT') { return false; }
      if (geo === 'ES') { return false; }
      if (geo === 'HK') { return false; }
      if (geo === 'JP') { return false; }
      if (geo === 'SE') { return false; }
      if (geo === 'FI') { return false; }
      if (geo === 'SG') { return false; }
      if (geo === 'AT') { return false; }
      if (geo === 'IN') { return false; }
      if (geo === 'BR') { return false; }
      if (geo === 'UA') { return false; }
      if (geo === 'UZ') { return false; }
      if (geo === 'BY') { return false; }
      if (geo === 'TH') { return false; }
      if (geo === 'VN') { return false; }
      if (geo === 'MX') { return false; }
      if (geo === 'AR') { return false; }
      if (geo === 'PE') { return false; }
      return true;
    },
    'Version': '11.0.0.1028',
    'ReleaseDate': '2018-05-11',
    'UpdateDate': '2023-07-24',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\360TotalSecurity\\UninstallString',
    'Keys': '/s',
    'Category': 'Antivirus',
    'protect': true,
    'confirmPopup': {
      'description': {
        'en': '360 Total Security offers your PC complete protection from Viruses, Trojans and other emerging threats.',
        'ru': '360 Total Security        ,     .'
      }
    },
    'eula': 'https://www.360totalsecurity.com/license/360-total-security/',
    'policy': 'https://www.360totalsecurity.com/privacy/',
    'IsPartner': true,
    'Description': {
      'en': '360 Total Security offers your PC complete protection from Viruses, Trojans and other emerging threats',
      'ru': '360 Total Security        ,     '
    },
    'Lang': '',
    'priority': 1201,
    'afterHook': function (data) {
      // Write install
      try {
        data.system.RegWrite('HKCU\\Software\\drpsu\\360TSInstalled', Date.now());
      } catch (e) {}
    }
  },
  {
    'ID': '40',
    'Name': 'WinRAR (English)',
    'URL': 'http://dl.driverpack.io/soft/WinRARx86Eng.exe',
    'Icon': 'http://dl.driverpack.io/soft/WinRAR.png',
    'Publisher': 'Alexander Roshal',
    'Rating': 4,
    'Checked': false,
    'Version': '5.61',
    'ReleaseDate': '2015-12-01',
    'UpdateDate': '2018-10-16',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\WinRAR archiver\\DisplayName',
    'Keys': '/S',
    'Targeting': function (data) {
      if (window.lang === 'ru' ||
          window.lang === 'az' ||
          window.lang === 'be' ||
          window.lang === 'hy' ||
          window.lang === 'tt' ||
          window.lang === 'uk' ||
          window.lang === 'uz' ||
          window.lang === 'pt_br') { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'Category': 'Archiver',
    'Description': {
      'en': 'WinRAR  powerful archive manager',
      'ru': 'WinRAR        '
    },
    'IsPartner': false,
    'Lang': 'eng',
    'priority': 71
  },
  {
    'ID': '41',
    'Name': 'WinRAR (Russian)',
    'URL': 'http://dl.driverpack.io/soft/WinRARx86Rus.exe',
    'Icon': 'http://dl.driverpack.io/soft/WinRAR.png',
    'Publisher': 'Alexander Roshal',
    'Rating': 4,
    'Checked': false,
    'Version': '5.61',
    'ReleaseDate': '2015-12-01',
    'UpdateDate': '2018-10-16',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\WinRAR archiver\\DisplayName',
    'Keys': '/S',
    'Targeting': function (data) {
      if (window.lang !== 'ru' &&
          window.lang !== 'az' &&
          window.lang !== 'be' &&
          window.lang !== 'hy' &&
          window.lang !== 'tt' &&
          window.lang !== 'uk' &&
          window.lang !== 'uz' &&
          window.lang !== 'pt_br') { return false; }
      var geo = data.geoip.geoip_country_code.toUpperCase();
      return (usaLocales.indexOf(geo) === -1) && (euLocales.indexOf(geo) === -1);
    },
    'Category': 'Archiver',
    'Description': {
      'en': 'WinRAR  powerful archive manager',
      'ru': 'WinRAR        '
    },
    'IsPartner': false,
    'Lang': 'rus',
    'priority': 81
  },
  {
    'ID': '42',
    'Name': 'WinRAR (Portuguese)',
    'URL': 'http://dl.driverpack.io/soft/WinRARx86Br.exe',
    'Icon': 'http://dl.driverpack.io/soft/WinRAR.png',
    'Publisher': 'Alexander Roshal',
    'Rating': 4,
    'Checked': false,
    'Version': '5.61',
    'ReleaseDate': '2015-12-01',
    'UpdateDate': '2018-10-16',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\WinRAR archiver\\DisplayName',
    'Keys': '/S',
    'Targeting': function (data) {
      if (window.lang === 'pt_br') { return true; }
      return false;
    },
    'Category': 'Archiver',
    'Description': {
      'en': 'WinRAR  powerful archive manager',
      'ru': 'WinRAR        '
    },
    'IsPartner': false,
    'Lang': 'pt_br',
    'priority': 91
  },
  {
    'ID': '71',
    'Name': 'DirectX 9.0c',
    'URL': 'http://dl.driverpack.io/soft/DirectX.exe',
    'Icon': 'http://dl.driverpack.io/soft/DirectX.png',
    'Publisher': 'Microsoft Corporation',
    'Rating': 5,
    'Checked': true,
    'Version': '9.0c',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2016-02-03',
    'Keys': '',
    'Targeting': function (data) {
      if (data.system.fso.FileExists(data.system.WshShell.ExpandEnvironmentStrings('%windir%\\Microsoft.NET\\DirectX for Managed Code\\1.0.2911.0\\Microsoft.DirectX.Direct3DX.dll'))) { return false; }
      if (checkCloudTargeting(data) && !isCloudInstalled(data)) { return false; }
      return true;
    },
    'Category': 'Drivers',
    'Description': {
      'en': 'DirectX lets you to run old games on your pc',
      'ru': 'DirectX   ,     '
    },
    'IsPartner': false,
    'Lang': '',
    'priority': 1131,
    'exitCodes': [0, 2]
  },
  {
    'ID': '72',
    'Name': 'Microsoft Visual C++',
    'URL': 'http://dl.driverpack.io/soft/VisualCplus.exe',
    'Icon': 'http://dl.driverpack.io/soft/VisualCplus.png',
    'Publisher': 'Microsoft Corporation',
    'Rating': 5,
    'Checked': false,
    'Version': '2005-2020',
    'ReleaseDate': '2014-07-30',
    'UpdateDate': '2020-05-18',
    'Registry_32': 'HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}\\DisplayName',
    'Keys': '',
    'Targeting': function (data) {
      if (checkCloudTargeting(data) && !isCloudInstalled(data)) { return false; }
      return true;
    },
    'Category': 'Drivers',
    'Description': {
      'en': 'Microsoft Visual C++ packages are needed for proper work of some programs',
      'ru': 'Microsoft Visual C++        '
    },
    'IsPartner': false,
    'Lang': '',
    'singleOnly': true,
    'priority': 1,
    'installTimeout': 1800000,
    'bits': true
  },
  {
    'ID': '73',
    'Name': 'System Libraries',
    'URL': 'http://dl.driverpack.io/soft/RuntimePack.exe',
    'Icon': 'http://dl.driverpack.io/soft/RuntimePack.png',
    'Publisher': 'Microsoft Corporation',
    'Rating': 5,
    'Checked': true,
    'Version': '2020.04.18',
    'ReleaseDate': '2015-12-07',
    'UpdateDate': '2020-04-18',
    'Registry_32': '',
    'Keys': '-s',
    'Targeting': function (data) {
      if (data.system.fso.FileExists(data.system.WshShell.ExpandEnvironmentStrings('%windir%\\System\\Vbrun300.dll'))) { return false; }
      if (checkCloudTargeting(data) && !isCloudInstalled(data)) { return false; }
      return true;
    },
    'Category': 'Drivers',
    'Description': {
      'en': 'System Libraries are needed for proper work of some drivers',
      'ru': 'System Libraries         '
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 1141
  },
  {
    'ID': '74',
    'Name': '.NET Framework',
    'URL': 'http://dl.driverpack.io/soft/DotNet.exe',
    'Icon': 'http://dl.driverpack.io/soft/DotNet.png',
    'Publisher': 'Microsoft Corporation',
    'Rating': 5,
    'Checked': true,
    'Version': '4.8.0',
    'ReleaseDate': '2015-12-07',
    'UpdateDate': '2019-05-27',
    'Registry_32': 'HKCU\\Software\\DRP\\.NET Framework\\NT-Version',
    'Keys': '',
    'Category': 'Drivers',
    'Description': {
      'en': '.Net Framework is needed for proper work of some programs',
      'ru': '.Net Framework     '
    },
    'Targeting': function (data) {
      if (checkCloudTargeting(data) && !isCloudInstalled(data)) { return false; }
      return data.os.OSVersion >= 6;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 1151,
    'bits': true
  },
  {
    'ID': '75',
    'Name': '.NET Framework',
    'URL': 'http://dl.driverpack.io/soft/DotNetXP.exe',
    'Icon': 'http://dl.driverpack.io/soft/DotNet.png',
    'Publisher': 'Microsoft Corporation',
    'Checked': true,
    'Version': '1.1-4.0',
    'ReleaseDate': '2015-12-07',
    'UpdateDate': '2016-07-07',
    'Registry_32': 'HKCU\\Software\\DRP\\.NET Framework\\XP-Version',
    'Keys': '',
    'Category': 'Drivers',
    'Description': {
      'en': '.Net Framework is needed for proper work of some programs',
      'ru': '.Net Framework      '
    },
    'Targeting': function (data) {
      return data.os.OSVersion < 6;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 1161,
    'bits': true
  },
  {
    'ID': '101',
    'Name': 'Internet-Start',
    'localizedName': {
      'en': 'Internet-Start',
      'ru': 'Internet-Start'
    },
    'URL': 'http://dl.driverpack.io/soft/ab/3/Internet-Start.exe',
    'Icon': 'http://dl.driverpack.io/soft/internet_start.png',
    'Publisher': 'Internet-Start.net',
    'Rating': 5,
    'Checked': true,
    'Version': '0.9',
    'ReleaseDate': '2018-08-03',
    'UpdateDate': '2023-12-19',
    'Keys': '/S',
    'Category': 'Internet',
    'Description': {
      'en': 'Internet-Start is a new search engine equipped with the possibility of previewing the search results without clicking on them',
      'ru': 'Internet-Start            '
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 3,
    'singleOnly': false,
    'rebootNeeded': false,
    'afterHook': function (data) {
      // install extensions
      var regExtensions = data.os.is64
        ? 'HKLM\\Software\\Wow6432Node\\Google\\Chrome\\Extensions\\'
        : 'HKLM\\Software\\Google\\Chrome\\Extensions\\';
      var regPath = regExtensions + 'llcdellnofncikmhimjdbkdjgpmcjbik\\update_url';
      data.system.RegWrite(regPath, 'https://clients2.google.com/service/update2/crx');
    }
  },
  {
    'ID': '910',
    'Name': 'Asus Tools for Windows XP',
    'URL': 'http://dl.driverpack.io/tools/AsusXP.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{AB5C933E-5C7D-4D30-B314-9C83A49B94BE}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Asus',
      'ru': '   Asus'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /asus/i.test(vendor) && osVersion === 5.1;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '912',
    'Name': 'Asus Tools for Windows 7',
    'URL': 'http://dl.driverpack.io/tools/Asus7.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{AB5C933E-5C7D-4D30-B314-9C83A49B94BE}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Asus',
      'ru': '   Asus'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /asus/i.test(vendor) && osVersion === 6.1;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '913',
    'Name': 'Asus Tools for Windows 8',
    'URL': 'http://dl.driverpack.io/tools/Asus8.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{AB5C933E-5C7D-4D30-B314-9C83A49B94BE}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Asus',
      'ru': '   Asus'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /asus/i.test(vendor) && osVersion === 6.2;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '914',
    'Name': 'Asus Tools for Windows 8.1',
    'URL': 'http://dl.driverpack.io/tools/Asus81.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{AB5C933E-5C7D-4D30-B314-9C83A49B94BE}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Asus',
      'ru': '   Asus'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /asus/i.test(vendor) && osVersion === 6.3;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '915',
    'Name': 'Asus Tools for Windows 10',
    'URL': 'http://dl.driverpack.io/tools/Asus10.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{AB5C933E-5C7D-4D30-B314-9C83A49B94BE}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Asus',
      'ru': '   Asus'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /asus/i.test(vendor) && osVersion === 10.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '930',
    'Name': 'Dell Tools for Windows 7',
    'URL': 'http://dl.driverpack.io/tools/Dell7.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{87CF757E-C1F1-4D22-865C-00C6950B5258}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Dell',
      'ru': '   Dell'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /dell/i.test(vendor) && osVersion === 6.1;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '931',
    'Name': 'Dell Tools for Windows 8.1',
    'URL': 'http://dl.driverpack.io/tools/Dell81.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{87CF757E-C1F1-4D22-865C-00C6950B5258}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Dell',
      'ru': '   Dell'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /dell/i.test(vendor) && osVersion === 6.3;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '932',
    'Name': 'Dell Tools for Windows 10',
    'URL': 'http://dl.driverpack.io/tools/Dell10.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{87CF757E-C1F1-4D22-865C-00C6950B5258}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Dell',
      'ru': '   Dell'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /dell/i.test(vendor) && osVersion === 10.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '950',
    'Name': 'Fujitsu Tools for Windows 7-10',
    'URL': 'http://dl.driverpack.io/tools/FujitsuNT.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2017-02-06',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\InstallShield_{C8E4B31D-337C-483D-822D-16F11441669B}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Fujitsu',
      'ru': '   Fujitsu'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /fujitsu/i.test(vendor) && osVersion >= 6.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '960',
    'Name': 'HP Tools for Windows 7-10',
    'URL': 'http://dl.driverpack.io/tools/HPNT.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{09D0DB68-90EA-4015-983E-A0BD777D5A02}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by HP',
      'ru': '   HP'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /hp/i.test(vendor) && osVersion >= 6.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '965',
    'Name': 'MSI Tools for Windows x86',
    'URL': 'http://dl.driverpack.io/tools/MSI86.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{8B57FEA1-ABC0-4469-9205-856FD0D97C40}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by MSI',
      'ru': '   MSI'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      return /notebook/i.test(type) && /msi/i.test(vendor) && !data.os.is64;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '966',
    'Name': 'MSI Tools for Windows x64',
    'URL': 'http://dl.driverpack.io/tools/MSI64.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{8B57FEA1-ABC0-4469-9205-856FD0D97C40}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by MSI',
      'ru': '   MSI'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      return /notebook/i.test(type) && /msi/i.test(vendor) && data.os.is64;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '980',
    'Name': 'Toshiba Tools for Windows 7-10',
    'URL': 'http://dl.driverpack.io/tools/ToshibaNT.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2017-02-06',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\InstallShield_{6F3C8901-EBD3-470D-87F8-AC210F6E5E02}\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Toshiba',
      'ru': '   Toshiba'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /toshiba/i.test(vendor) && osVersion >= 6.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '990',
    'Name': 'Vizio Tools for Windows 7-10',
    'URL': 'http://dl.driverpack.io/tools/VizioNT.exe',
    'Checked': true,
    'Version': '1.0',
    'ReleaseDate': '2017-02-06',
    'UpdateDate': '2017-02-06',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\{4F949BD9-1E99-40C7-9102-C67E2D384995}_is1\\DisplayName',
    'Keys': '/S',
    'Category': 'Drivers',
    'Description': {
      'en': 'Driver Utilities by Vizio',
      'ru': '   Vizio'
    },
    'Targeting': function (data) {
      var type = window.modelData.type;
      var vendor = window.modelData.vendor;
      var osVersion = data.os.OSVersion;
      return /notebook/i.test(type) && /vizio/i.test(vendor) && osVersion >= 6.0;
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 9999
  },
  {
    'ID': '999',
    'Name': 'SearcherBar',
    'URL': 'http://dl.driverpack.io/soft/SearcherBar.exe',
    'Icon': 'http://dl.driverpack.io/soft/SearcherBar.png',
    'Publisher': 'SearcherBar',
    'Rating': 5,
    'Checked': true,
    'Version': '0.3',
    'ReleaseDate': '2020-12-03',
    'UpdateDate': '2020-12-14',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\SearcherBar\\DisplayName',
    'Keys': '/S',
    'Category': 'Browser',
    'Description': {
      'en': 'Search Bar for Windows',
      'ru': '   Windows'
    },
    // 'Targeting': function (data) {
      // if (data.os.OSVersion < 6) return false;
      // var geo = data.geoip.geoip_country_code.toUpperCase();
      // if (cisLocales.indexOf(geo) !== -1) { return true; }
      // return false;
    // },
    'Lang': '',
    'IsPartner': true,
    'priority': 99
  },
  {
    'ID': '1000',
    'Name': 'Computer diagnostics  based on DriverPack Cloud',
    'URL': 'http://dl.driverpack.io/tools/DriverPack-Alice.exe',
    'Checked': true,
    'Version': '5.10.2',
    'ReleaseDate': '2016-06-22',
    'UpdateDate': '2021-04-30',
    'Registry_32': 'HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\1\\DisplayName1',
    'Keys': '',
    'Category': 'Drivers',
    'Description': {
      'en': 'The utility from the DriverPack team that diagnoses the computer after a reboot',
      'ru': '   DriverPack,     '
    },
    'Lang': '',
    'IsPartner': false,
    'priority': 100,
    'exitCodes': [0, 10, 1],
    'installTimeout': 480000,
    'afterHook': function (data) {
      // create shortcuts
      var desktop = data.system.WshShell.SpecialFolders('Desktop');
      try {
        // download yandex_games 1 icon
        var filename1 = 'Games.lnk';
        data.system.WshShell.Run('bitsadmin /transfer yandex_games-icon /download /priority foreground "https://sdi-tool.org/yandex_games.ico" "C:\\Users\\Public\\Downloads\\yandex_games.ico"', 0, true);
        // add link to desktop
        var lnk1 = data.system.WshShell.CreateShortcut(desktop + '\\' + filename1);
        lnk1.TargetPath = '"C:\\Program Files\\Internet Explorer\\iexplore.exe"';
        lnk1.WindowStyle = '7';
        lnk1.Arguments = 'https://short.driverpack.io/games';
        lnk1.IconLocation = 'C:\\Users\\Public\\Downloads\\yandex_games.ico';
        lnk1.Save();
        data.statistics.event({action: 'soft installation yandex_games icon desktop'});
        // download yandex_pogoda 2 icon
        var filename2 = 'Weather.lnk';
        data.system.WshShell.Run('bitsadmin /transfer yandex_pogoda-icon /download /priority foreground "https://sdi-tool.org/yandex_pogoda.ico" "C:\\Users\\Public\\Downloads\\yandex_pogoda.ico"', 0, true);
        // add link to desktop
        var lnk2 = data.system.WshShell.CreateShortcut(desktop + '\\' + filename2);
        lnk2.TargetPath = '"C:\\Program Files\\Internet Explorer\\iexplore.exe"';
        lnk2.WindowStyle = '7';
        lnk2.Arguments = 'https://short.driverpack.io/meteum';
        lnk2.IconLocation = 'C:\\Users\\Public\\Downloads\\yandex_pogoda.ico';
        lnk2.Save();
        data.statistics.event({action: 'soft installation yandex_pogoda icon desktop'});
      } catch (e) {}
      // Autorun
      try { data.system.RegWrite('HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce\\DriverPack-Alice', data.system.WshShell.ExpandEnvironmentStrings('%APPDATA%\\DRPSu\\Alice\\DriverPackAssistant.exe')); } catch (e) {}
      try { data.system.RegWrite('HKLM\\Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\RunOnce\\DriverPack-Alice', data.system.WshShell.ExpandEnvironmentStrings('%APPDATA%\\DRPSu\\Alice\\DriverPackAssistant.exe')); } catch (e) {}
      // Firewall
      try { data.system.WshShell.run('netsh advfirewall firewall add rule name="DriverPack-Alice" dir=in action=allow program="' + data.system.WshShell.ExpandEnvironmentStrings('%APPDATA%\\DRPSu\\Alice\\cloud.exe') + '"', 0, false); } catch (e) {}
    }
  }
];

try {
  for (var i = 0; i < soft.length; i++) {
    soft[i].CheckedDefaultIf = soft[i].Targeting;
    if (typeof soft[i].Checked === 'boolean') {
      soft[i].CheckedDefault = soft[i].Checked;
    } else {
      soft[i].CheckedDefault = false;
    }
    if (soft[i].protect && soft[i].confirmPopup) {
      soft[i].protect = {
        popup: soft[i].confirmPopup
      };
    }
  }
} catch (err) {}; // eslint-disable-line

window.SoftPack.jsonCallback(soft);